#include <iostream>
#include <cstdio>
#include <vector>
#include <cassert>
#include <algorithm>
using namespace std;

int INF = 2147483647;

typedef vector<int> vi;

template <class T> int size(const T &x) { return x.size(); }

const int ID = INF;
int f(int a, int b) { return min(a, b); }
struct segment_tree {
    int n;
    vi data, lazy;
    segment_tree() {}
    segment_tree(const vi &arr) : n(size(arr)), data(4*n), lazy(4*n, INF) {
        mk(arr, 0, n-1, 0);
    }
    int mk(const vi &arr, int l, int r, int i) {
        if (l == r) return data[i] = arr[l];
        int m = (l + r) / 2;
        return data[i] = f(mk(arr, l, m, 2*i+1), mk(arr, m+1, r, 2*i+2));
    }
    int query(int a, int b) { return q(a, b, 0, n-1, 0); }
    int q(int a, int b, int l, int r, int i) {
        propagate(l, r, i);
        if (r < a || b < l) return ID;
        if (a <= l && r <= b) return data[i];
        int m = (l + r) / 2;
        return f(q(a, b, l, m, 2*i+1), q(a, b, m+1, r, 2*i+2));
    }
    void range_update(int a, int b, int v) {
        ru(a, b, v, 0, n - 1, 0);
    }
    int ru(int a, int b, int v, int l, int r, int i) {
        propagate(l, r, i);
        if (l > r) return ID;
        if (r < a || b < l) return data[i];
        if (l == r) return data[i] = min(data[i], v);
        if (a <= l && r <= b) return min((lazy[i] = v), data[i]);
        int m = (l + r) / 2;
        return data[i] = f(ru(a, b, v, l, m, 2*i+1), ru(a, b, v, m+1, r, 2*i+2));
    }
    void propagate(int l, int r, int i) {
        if (l > r || lazy[i] == INF) return;
        data[i] = min(lazy[i], data[i]);
        if (l < r) {
            if (lazy[2*i+1] == INF) lazy[2*i+1] = lazy[i];
            else lazy[2*i+1] = min(lazy[i], lazy[2*i+1]);
            if (lazy[2*i+2] == INF) lazy[2*i+2] = lazy[i];
            else lazy[2*i+2] = min(lazy[i], lazy[2*i+2] );
        }
        lazy[i] = INF;
    }


};

typedef long long ll;
struct man {
    int x, y, z;
    man() {}
    man(int _x, int _y, int _z) {
        x = _x;
        y = _y;
        z = _z;
    }
    bool operator < (const man &other) const {
        if (x != other.x) return x < other.x;
        if (y != other.y) return y < other.y;
        if (z != other.z) return z < other.z;
        return false;
    }
};

int main() {
    int ts;
    scanf("%d\n", &ts);
    for (int t = 0; t < ts; t++) {
        int n;
        scanf("%d\n", &n);

        vector<man> men(n);

        for (int i = 0; i < n; i++) {
            scanf("%d %d %d\n", &men[i].x, &men[i].y, &men[i].z);
            men[i].x--;
            men[i].y--;
            men[i].z--;
        }

        sort(men.begin(), men.end());

        vi arr(n, INF);

        segment_tree st(arr);

        int dom = 0;
        for (int i = 0; i < n; i++) {
            //printf("%d %d %d\n", men[i].x, men[i].y, men[i].z);

            int mn = st.query(0, men[i].y);

            //printf("%d\n", mn);
            if (mn < men[i].z) {

            } else {
                dom++;
            }

            st.range_update(men[i].y, n - 1, men[i].z);

        }


        printf("%d\n", dom);
    }
}

